# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=4

# ebuild generated by hackport 0.2.18.9999

CABAL_FEATURES="bin"
inherit eutils haskell-cabal

DESCRIPTION="manage files with git, without checking their contents into git"
HOMEPAGE="http://git-annex.branchable.com/"
SRC_URI="mirror://hackage/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="assistant dbus doc inotify pairing s3 test webapp"
RESTRICT=test # don't seem to like our git environment much

RDEPEND=">=dev-vcs/git-1.7.7" # TODO: add more deps?
DEPEND="${RDEPEND}
		dev-haskell/SafeSemaphore
		dev-haskell/async
		dev-haskell/yesod
		test? ( dev-haskell/hunit
			dev-haskell/testpack
		)
		dev-haskell/bloomfilter
		>=dev-haskell/cabal-1.8
		dev-haskell/dataenc
		dev-haskell/edit-distance
		dev-haskell/extensible-exceptions
		dev-haskell/hslogger
		dev-haskell/http
		dev-haskell/ifelse
		dev-haskell/json[generic]
		dev-haskell/lifted-base
		dev-haskell/missingh
		dev-haskell/monad-control
		dev-haskell/mtl
		>=dev-haskell/network-2.4.0.1
		dev-haskell/pcre-light
		>=dev-haskell/quickcheck-2.1
		dev-haskell/sha
		dev-haskell/text
		dev-haskell/time
		dev-haskell/transformers-base
		dev-haskell/utf8-string
		>=dev-lang/ghc-7.4
		dev-lang/perl
		assistant? ( >=dev-haskell/stm-2.3 )
		dbus? ( dev-haskell/dbus )
		inotify? ( dev-haskell/hinotify )
		s3? ( dev-haskell/hs3 )
		webapp? (
			assistant? (
				dev-haskell/case-insensitive
				dev-haskell/http-types
				dev-haskell/transformers
				dev-haskell/wai
				dev-haskell/wai-logger
				dev-haskell/warp
				dev-haskell/blaze-builder
				dev-haskell/blaze-html
				dev-haskell/crypto-api
				dev-haskell/hamlet
				dev-haskell/clientsession
				dev-haskell/data-default
				dev-haskell/yesod
				>=dev-haskell/yesod-default-1.1.0
				dev-haskell/yesod-static
			)
			pairing? ( dev-haskell/network-multicast
				dev-haskell/network-info
			)
		)
		doc? ( www-apps/ikiwiki net-misc/rsync )"
# dev-lang/perl is to build the manpages
# www-apps/ikiwiki and net-misc/rsync used to build the rest of the docs

src_prepare() {
	#epatch "${FILESDIR}"/${P}-no-tf.patch
	epatch "${FILESDIR}"/yesod-depend.patch
	echo 'mans: $(mans)' >>"${S}"/Makefile
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag assistant Assistant) \
		$(cabal_flag dbus Dbus) \
		$(cabal_flag inotify Inotify) \
		$(cabal_flag pairing Pairing) \
		$(cabal_flag s3 S3) \
		$(cabal_flag webapp Webapp)
}

src_compile() {
	haskell-cabal_src_compile
	use doc && emake docs
	emake mans
}

src_test() {
	export GIT_CONFIG=${T}/temp-git-config
	git config user.email "git@src_test"
	git config user.name "Mr. ${P} The Test"

	emake test
}

src_install() {
	haskell-cabal_src_install
	emake install-mans DESTDIR="${D}" PREFIX="${EPREFIX}/usr"
	use doc && emake install-docs DESTDIR="${D}" PREFIX="${EPREFIX}/usr"
	mv "${ED}"/usr/share/doc/{${PN},${PF}}
	dodoc CHANGELOG README
}
